-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- CapeClock.db Alter Statements
-- Alter statements to keep existing clocks up to date
-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- Notes:
-- 	remember all alter table add column text needs to be not null default ''
--
-- -------------------------------------------------------------------------------------------------------------------------------------------------

-- table readertype

delete from readertype;
insert into readertype (id,wieg,bitlen,char,desc) values (1, 1, 34, 0, 'KeyProx');
insert into readertype (id,wieg,bitlen,char,desc) values (2, 1, 34, 0, 'Proximity');
insert into readertype (id,wieg,bitlen,char,desc) values (3, 1, 10, 1, 'Keypad');

insert into readertype (id,wieg,bitlen,char,desc) values (261, 0, 0, 0, 'Bioscrypt Identify');
insert into readertype (id,wieg,bitlen,char,desc) values (262, 0, 0, 0, 'Bioscrypt Verify');
insert into readertype (id,wieg,bitlen,char,desc) values (265, 0, 0, 0, 'FS83 Identify');
insert into readertype (id,wieg,bitlen,char,desc) values (266, 0, 0, 0, 'FS83 Verify');
insert into readertype (id,wieg,bitlen,char,desc) values (289, 0, 0, 0, 'Lumidigm Identify');
insert into readertype (id,wieg,bitlen,char,desc) values (290, 0, 0, 0, 'Lumidigm Verify');
insert into readertype (id,wieg,bitlen,char,desc) values (33057, 0, 0, 0, 'Lumidigm ID Verify');

-- table area
alter table area add column pc integer default 2;
alter table area add column deleted integer not null default 0;
alter table area add column tstamp integer not null default 0;

-- table route
alter table route add column pc integer default 2;

-- table brand
alter table brand add column deleted integer not null default 0;
alter table brand add column tstamp integer not null default 0;

-- table chore
update chore set olddatatime = 120, checkolddatainterval = 60 where id = 1;	-- turns on this chore by default (may want to remove this from alter.sql in a few versions time)

-- table _info
alter table _info add column processorversion integer default 0;
alter table _info add column hostversion integer default 0;

-- table unknowncard
alter table unknowncard add column deleted integer not null default 0;
alter table unknowncard add column tstamp integer not null default 0;

-- table clocking
alter table clocking add column del integer default 0;
alter table clocking add column dt1 integer default 0;
alter table clocking add column dt2 text not null default '';
alter table clocking add column tstamp integer not null default 0;
alter table clocking add column fpq integer default 0;
alter table clocking add column lat real not null default 0;
alter table clocking add column lng real not null default 0;
create unique index if not exists clocking_en_key on clocking(en,t,ty,stat);

-- table empproc
create table if not exists empproc (
	en text not null primary key,
	monstart integer,
	monend integer,
	monlunch integer,
	monexpected integer,
	tuestart integer,
	tueend integer,
	tuelunch integer,
	tueexpected integer,
	wedstart integer,
	wedend integer,
	wedlunch integer,
	wedexpected integer,
	thustart integer,
	thuend integer,
	thulunch integer,
	thuexpected integer,
	fristart integer,
	friend integer,
	frilunch integer,
	friexpected integer,
	satstart integer,
	satend integer,
	satlunch integer,
	satexpected integer,
	sunstart integer,
	sunend integer,
	sunlunch integer,
	sunexpected integer,
	pc integer default 2,
	runningtotals integer default -1,
	balancing integer default -1,
	autoendday integer default -1,
	leaveautoapproved integer default -1,
	rounding integer default -1	
);
alter table empproc add column balancing integer default -1;
alter table empproc add column runningtotals integer default -1;
alter table empproc add column autoendday integer default -1;
alter table empproc add column leaveautoapproved integer default -1;
alter table empproc add column rounding integer default -1;
alter table empproc add column pc integer default 2;
alter table empproc add column deleted integer not null default 0;
alter table empproc add column tstamp integer not null default 0;


-- table hour
create table if not exists hour (
  id integer not null primary key,
  processed integer,
	en text not null,
	date integer,
	desc text not null default '', 
	hours1 integer,
	hours2 integer,
	hours3 integer,
	hours4 integer,
	hours5 integer,
	hours6 integer,
	hours7 integer,
	hours8 integer,
  hours9 integer,
	orhours1 integer default -1,
	orhours2 integer default -1,
	orhours3 integer default -1,
	orhours4 integer default -1,
	orhours5 integer default -1,
	orhours6 integer default -1,
	orhours7 integer default -1,
	orhours8 integer default -1,
	orhours9 integer default -1,
	lunch integer,
	orlunch integer default -1,
	suen text not null default '',
	stime integer,
	clockings text not null default '',
	awol integer default 0,
	expected text not null default '',
	comment text not null default '',
	runningtotal integer default 0,
	pc integer default 2,
	orrunningtotal integer default -1	
);
create index if not exists hour_namekey on hour(date,en);
create index if not exists hour_processkey on hour(processed,date);


alter table hour add column awol integer default 0;
alter table hour add column expected text not null default '';
alter table hour add column comment text not null default '';
alter table hour add column runningtotal integer default 0;
alter table hour add column suen text not null default '';
alter table hour add column pc integer default 2;
alter table hour add column orrunningtotal integer default -1;


--create table if not exists accumtime (
--  id integer not null primary key,
--  en text not null,
--  date integer,
--  hours integer,
--  orhours integer default -1,
--	suen text not null default '',
--	stime integer,
--	processed integer,
--  pc integer default 2
--);
-- alter table accumtime add column processed integer default 0;
-- alter table accumtime add column pc integer default 2;
-- alter table accumtime add column processed integer default 0;
-- alter table accumtime add column tstamp integer not null default 0;

-- table leave
create table if not exists leave (
  id integer not null primary key,
  fromdate integer,
  todate integer,
  en text not null default '',
  reason text not null default '',
  partial integer default 1,
  type integer,
	suen text not null default '',
	stime integer,
	scomment text not null default '',
	sdel integer,
	processed integer,
	pc integer default 2
);
alter table leave add column processed integer default 0;
alter table leave add column pc integer default 2;
alter table leave add column deleted integer not null default 0;
alter table leave add column tstamp integer not null default 0;

-- table holiday
create table if not exists holiday (
  id integer not null primary key,
  date integer,
  desc text not null default '',
  pc integer default 0,
	auto integer default 0	
);
alter table holiday add column pc integer default 2;
alter table holiday add column auto integer default 0;
alter table holiday add column deleted integer not null default 0;
alter table holiday add column tstamp integer not null default 0;
insert into holiday (id,date,desc) values (1,1230163200,'Christmas');

-- table leavetype
create table if not exists leavetype (
  id integer not null primary key,
  desc text not null,
  paid integer,
  flexi integer,
  cat integer,
  pc integer default 2,
	fgcolor integer default 16777215,
	bgcolor integer default 0,
	payrollcode text not null default '',
  expcode integer default 1	
);

alter table leavetype add column fgcolor integer default 16777215;
alter table leavetype add column bgcolor integer default 0;
alter table leavetype add column pc integer default 2;
alter table leavetype add column payrollcode text not null default '';
alter table leavetype add column expcode integer default 1;
alter table leavetype add column deleted integer not null default 0;
alter table leavetype add column tstamp integer not null default 0;

insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (1, 'Paid Leave', 1, 0, 7, 16777215, 32896);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (2, 'Sick Leave', 1, 0, 8, 16777215, 16711680);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (3, 'Flexi Leave', 1, 1, 7, 16777215, 4243520);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (4, 'Unpaid Leave', 0, 0, 0, 16777215, 32768);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (5, 'Other Leave', 1, 0, 7, 16777215, 16711935);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (6, 'Family Responsibility', 1, 0, 7, 16777215, 255);

update leavetype set fgcolor=16777215, bgcolor=32896 where id =1 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=16711680 where id =2 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=4243520 where id =3 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=32768 where id =4 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=16711935 where id =5 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=255 where id =6 and fgcolor = 16777215 and bgcolor = 0;

-- table gloproc
create table if not exists gloproc (
  id integer not null primary key,
  autoproc integer default 1,
  cat1 text not null default 'Extra',
  cat2 text not null default 'Normal',
  cat3 text not null default 'Overtime',
  cat4 text not null default 'Saturday',
  cat5 text not null default 'Sunday',
  cat6 text not null default 'Holiday',
  cat7 text not null default 'Paid Leave',
  cat8 text not null default 'Sick Leave',
  cat9 text not null default 'Variance',
  balancing integer default 1,
  rounding integer default 15,
  extracat integer default 1,
  normalcat integer default 2,
  overtimecat integer default 3,
  satcat integer default 4,
  suncat integer default 5,
  holidaycat integer default 6,
  variancecat integer default 9,
  sunday text not null default 'Sunday',
  monday text not null default 'Monday',
  tuesday text not null default 'Tuesday',
  wednesday text not null default 'Wednesday',
  thursday text not null default 'Thursday',
  friday text not null default 'Friday',
  saturday text not null default 'Saturday',
  lastdate integer default 1167562800,
  autoendday integer default 1,
  runningtotals integer default 0,
  pc integer default 2,
  leaveautoapproved integer default 1,
  threshold1 integer default 0,
	threshold2 integer default 0,
	threshold3 integer default 0,
	threshold4 integer default 0,
	threshold5 integer default 0,
	threshold6 integer default 0,
	threshold7 integer default 0,
	threshold8 integer default 0,
	threshold9 integer default 0		
);
alter table gloproc add column autoendday integer default 1;
alter table gloproc add column runningtotals integer default 1;
alter table gloproc add column lastdate integer default 0;
alter table gloproc add column leaveautoapproved integer default 1;
alter table gloproc add column extracat integer default 1;
alter table gloproc add column normalcat integer default 2;
alter table gloproc add column overtimecat integer default 3;
alter table gloproc add column holidaycat integer default 6;
alter table gloproc add column variancecat integer default 9;
alter table gloproc add column pc integer default 2;  
alter table gloproc add column sunday text not null default 'Sunday';
alter table gloproc add column monday text not null default 'Monday';
alter table gloproc add column tuesday text not null default 'Tuesday';
alter table gloproc add column wednesday text not null default 'Wednesday';
alter table gloproc add column thursday text not null default 'Thursday';
alter table gloproc add column friday text not null default 'Friday'; 
alter table gloproc add column saturday text not null default 'Saturday';
alter table gloproc add column threshold1 integer default 0;
alter table gloproc add column threshold2 integer default 0;
alter table gloproc add column threshold3 integer default 0;
alter table gloproc add column threshold4 integer default 0;
alter table gloproc add column threshold5 integer default 0;
alter table gloproc add column threshold6 integer default 0;
alter table gloproc add column threshold7 integer default 0;
alter table gloproc add column threshold8 integer default 0;
alter table gloproc add column threshold9 integer default 0;
insert into gloproc (id) values (1);
alter table gloproc add column deleted integer not null default 0;
alter table gloproc add column tstamp integer not null default 0;

-- table menucat
create table if not exists menucat (
	id integer not null primary key,
	catno integer,
	desc text not null,
	disabled integer default 0,
	pc integer default 2,
	language text not null default "english"
);
alter table menucat add column pc integer default 2;
alter table menucat add column language text not null default "english";
alter table menucat add column deleted integer not null default 0;
alter table menucat add column tstamp integer not null default 0;
alter table menucat add column model integer not null default 0;
create unique index if not exists menucat_catkey on menucat(language,model,catno);

-- table menuitem
create table if not exists menuitem (
	id integer not null primary key,
	catno integer,
	itemno integer,
	desc text not null,
	seqid integer,
	disabled integer default 0,
	pc integer default 2,
	language text not null default "english"
);
alter table menuitem add column pc integer default 2;
alter table menuitem add column language text not null default "english";
alter table menuitem add column deleted integer not null default 0;
alter table menuitem add column tstamp integer not null default 0;
alter table menuitem add column model integer not null default 0;
create unique index if not exists menuitem_catitemkey on menuitem(language,model,catno,itemno);

--
-- Menu changes 
-- are in altermenus.sql
--
-- Add extra menu items to that file!
-- altermenus.sql should not be run directly, rather use db_alter_menus
--

-- table payroll
create table if not exists payroll (
	id integer not null primary key,
	name text not null default '',
	phpname text not null default '',
	csvname text not null default '',
	sitecode text not null default '',
	fromdate integer not null default 0, 
	todate integer not null default 0,
	catcode1 text not null default '',
	catcode2 text not null default '',
	catcode3 text not null default '',
	catcode4 text not null default '',
	catcode5 text not null default '',
	catcode6 text not null default '',
	catcode7 text not null default '',
	catcode8 text not null default '',
	catcode9 text not null default '',
	expcode1 integer not null default 1,
	expcode2 integer not null default 1,
	expcode3 integer not null default 1,
	expcode4 integer not null default 1,
	expcode5 integer not null default 1,
	expcode6 integer not null default 1,
	expcode7 integer not null default 1,
	expcode8 integer not null default 1,
	expcode9 integer not null default 1,
	defaultexp integer not null default 0,
	stdtime1 integer not null default 0,
	cat1intime1 integer not null default 1,
	cat2intime1 integer not null default 0,
	cat3intime1 integer not null default 0,
	cat4intime1 integer not null default 0,
	cat5intime1 integer not null default 0,
	cat6intime1 integer not null default 0,
	cat7intime1 integer not null default 0,
	cat8intime1 integer not null default 0,
	cat9intime1 integer not null default 0,
	time1overflowcat integer not null default 0,
	time1getfrom1 integer not null default 0,
	time1getfrom2 integer not null default 0,
	time1getfrom3 integer not null default 0,
	time1getfrom4 integer not null default 0,
	stdtime2 integer not null default 0,
	cat1intime2 integer not null default 0,
	cat2intime2 integer not null default 1,
	cat3intime2 integer not null default 0,
	cat4intime2 integer not null default 0,
	cat5intime2 integer not null default 0,
	cat6intime2 integer not null default 0,
	cat7intime2 integer not null default 0,
	cat8intime2 integer not null default 0,
	cat9intime2 integer not null default 0,
	time2overflowcat integer not null default 0,
	time2getfrom1 integer not null default 0,
	time2getfrom2 integer not null default 0,
	time2getfrom3 integer not null default 0,
	time2getfrom4 integer not null default 0,
	stdtime3 integer not null default 0,
	cat1intime3 integer not null default 0,
	cat2intime3 integer not null default 0,
	cat3intime3 integer not null default 1,
	cat4intime3 integer not null default 0,
	cat5intime3 integer not null default 0,
	cat6intime3 integer not null default 0,
	cat7intime3 integer not null default 0,
	cat8intime3 integer not null default 0,
	cat9intime3 integer not null default 0,
	time3overflowcat integer not null default 0,
	time3getfrom1 integer not null default 0,
	time3getfrom2 integer not null default 0,
	time3getfrom3 integer not null default 0,
	time3getfrom4 integer not null default 0,
	stdtime4 integer not null default 0,
	cat1intime4 integer not null default 0,
	cat2intime4 integer not null default 0,
	cat3intime4 integer not null default 0,
	cat4intime4 integer not null default 1,
	cat5intime4 integer not null default 0,
	cat6intime4 integer not null default 0,
	cat7intime4 integer not null default 0,
	cat8intime4 integer not null default 0,
	cat9intime4 integer not null default 0,
	time4overflowcat integer not null default 0,
	time4getfrom1 integer not null default 0,
	time4getfrom2 integer not null default 0,
	time4getfrom3 integer not null default 0,
	time4getfrom4 integer not null default 0,
	overridecat1 integer not null default 0,
	overridecat2 integer not null default 0,
	overridecat3 integer not null default 0,
	overridecat4 integer not null default 0,
	overridecat5 integer not null default 0,
	overridecat6 integer not null default 0,
	overridecat7 integer not null default 0,
	overridecat8 integer not null default 0,
	overridecat9 integer not null default 0,
	overridetime1 integer not null default 0,
	overridetime2 integer not null default 0,
	overridetime3 integer not null default 0,
	overridetime4 integer not null default 0,
	overridetime5 integer not null default 0,
	overridetime6 integer not null default 0,
	overridetime7 integer not null default 0,
	overridetime8 integer not null default 0,
	overridetime9 integer not null default 0
);	
alter table payroll add column defaultexp integer not null default 0;
alter table payroll add column stdtime1 integer not null default 0;
alter table payroll add column cat1intime1 integer not null default 0;
alter table payroll add column cat2intime1 integer not null default 1;
alter table payroll add column cat3intime1 integer not null default 1;
alter table payroll add column cat4intime1 integer not null default 0;
alter table payroll add column cat5intime1 integer not null default 0;
alter table payroll add column cat6intime1 integer not null default 1;
alter table payroll add column cat7intime1 integer not null default 1;
alter table payroll add column cat8intime1 integer not null default 1;
alter table payroll add column cat9intime1 integer not null default 0;
alter table payroll add column time1overflowcat integer not null default 0;
alter table payroll add column time1getfrom1 integer not null default 0;
alter table payroll add column time1getfrom2 integer not null default 0;
alter table payroll add column time1getfrom3 integer not null default 0;
alter table payroll add column time1getfrom4 integer not null default 0;
alter table payroll add column stdtime2 integer not null default 0;
alter table payroll add column cat1intime2 integer not null default 0;
alter table payroll add column cat2intime2 integer not null default 0;
alter table payroll add column cat3intime2 integer not null default 0;
alter table payroll add column cat4intime2 integer not null default 0;
alter table payroll add column cat5intime2 integer not null default 0;
alter table payroll add column cat6intime2 integer not null default 0;
alter table payroll add column cat7intime2 integer not null default 0;
alter table payroll add column cat8intime2 integer not null default 0;
alter table payroll add column cat9intime2 integer not null default 0;
alter table payroll add column time2overflowcat integer not null default 0;
alter table payroll add column time2getfrom1 integer not null default 0;
alter table payroll add column time2getfrom2 integer not null default 0;
alter table payroll add column time2getfrom3 integer not null default 0;
alter table payroll add column time2getfrom4 integer not null default 0;
alter table payroll add column stdtime3 integer not null default 0;
alter table payroll add column cat1intime3 integer not null default 0;
alter table payroll add column cat2intime3 integer not null default 0;
alter table payroll add column cat3intime3 integer not null default 0;
alter table payroll add column cat4intime3 integer not null default 0;
alter table payroll add column cat5intime3 integer not null default 0;
alter table payroll add column cat6intime3 integer not null default 0;
alter table payroll add column cat7intime3 integer not null default 0;
alter table payroll add column cat8intime3 integer not null default 0;
alter table payroll add column cat9intime3 integer not null default 0;
alter table payroll add column time3overflowcat integer not null default 0;
alter table payroll add column time3getfrom1 integer not null default 0;
alter table payroll add column time3getfrom2 integer not null default 0;
alter table payroll add column time3getfrom3 integer not null default 0;
alter table payroll add column time3getfrom4 integer not null default 0;
alter table payroll add column stdtime4 integer not null default 0;
alter table payroll add column cat1intime4 integer not null default 0;
alter table payroll add column cat2intime4 integer not null default 0;
alter table payroll add column cat3intime4 integer not null default 0;
alter table payroll add column cat4intime4 integer not null default 0;
alter table payroll add column cat5intime4 integer not null default 0;
alter table payroll add column cat6intime4 integer not null default 0;
alter table payroll add column cat7intime4 integer not null default 0;
alter table payroll add column cat8intime4 integer not null default 0;
alter table payroll add column cat9intime4 integer not null default 0;
alter table payroll add column time4overflowcat integer not null default 0;
alter table payroll add column time4getfrom1 integer not null default 0;
alter table payroll add column time4getfrom2 integer not null default 0;
alter table payroll add column time4getfrom3 integer not null default 0;
alter table payroll add column time4getfrom4 integer not null default 0;
alter table payroll add column overridecat1 integer not null default 0;
alter table payroll add column overridecat2 integer not null default 0;
alter table payroll add column overridecat3 integer not null default 0;
alter table payroll add column overridecat4 integer not null default 0;
alter table payroll add column overridecat5 integer not null default 0;
alter table payroll add column overridecat6 integer not null default 0;
alter table payroll add column overridecat7 integer not null default 0;
alter table payroll add column overridecat8 integer not null default 0;
alter table payroll add column overridecat9 integer not null default 0;
alter table payroll add column overridetime1 integer not null default 0;
alter table payroll add column overridetime2 integer not null default 0;
alter table payroll add column overridetime3 integer not null default 0;
alter table payroll add column overridetime4 integer not null default 0;
alter table payroll add column overridetime5 integer not null default 0;
alter table payroll add column overridetime6 integer not null default 0;
alter table payroll add column overridetime7 integer not null default 0;
alter table payroll add column overridetime8 integer not null default 0;
alter table payroll add column overridetime9 integer not null default 0;
alter table payroll add column deleted integer not null default 0;
alter table payroll add column tstamp integer not null default 0;

-- table seq
create table if not exists seq (
	id integer not null primary key,
	seqid integer,
	author text not null default '',
	name text not null default '',
	version integer,
	editdate integer,
	pc integer,
	compiled integer,
	notes text not null default '',
	bundy text not null default '',
	pcode text not null default ''
);
alter table seq add column il text not null default '';
alter table seq add column deleted integer not null default 0;
alter table seq add column tstamp integer not null default 0;

-- table company
create table if not exists company (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table company add column deleted integer not null default 0;
alter table company add column tstamp integer not null default 0;

-- table branch
create table if not exists branch (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table branch add column deleted integer not null default 0;
alter table branch add column tstamp integer not null default 0;

-- table dept
create table if not exists dept (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table dept add column pc integer default 2;
alter table dept add column deleted integer not null default 0;
alter table dept add column tstamp integer not null default 0;

-- table center
create table if not exists center (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table center add column deleted integer not null default 0;
alter table center add column tstamp integer not null default 0;

-- table cat
create table if not exists cat (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table cat add column deleted integer not null default 0;
alter table cat add column tstamp integer not null default 0;

-- table payscale
create table if not exists payscale (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table payscale add column deleted integer not null default 0;
alter table payscale add column tstamp integer not null default 0;

-- table emptype
create table if not exists emptype (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table emptype add column deleted integer not null default 0;
alter table emptype add column tstamp integer not null default 0;

-- table workgroup
create table if not exists workgroup (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table workgroup add column deleted integer not null default 0;
alter table workgroup add column tstamp integer not null default 0;

-- table job
create table if not exists job (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table job add column deleted integer not null default 0;
alter table job add column tstamp integer not null default 0;

-- table emp
alter table emp add column companyid integer default 0;
alter table emp add column branchid integer default 0;
alter table emp add column centerid integer default 0;
alter table emp add column catid integer default 0;
alter table emp add column scaleid integer default 0;
alter table emp add column emptypeid integer default 0;
alter table emp add column workgroupid integer default 0;
alter table emp add column jobid integer default 0;
alter table emp add column payid text not null default '';
alter table emp add column payexporttype integer not null default 0;
alter table emp add column editmode integer not null default 0;
create index if not exists emp_exdatekey on emp(exdate);
alter table emp add column deleted integer not null default 0;
alter table emp add column tstamp integer not null default 0;
alter table emp add column idno text not null default '';

-- table thisdev
alter table thisdev add column special integer default 0;
alter table thisdev add column dateformat integer default 6;
alter table thisdev add column advancedhw integer default 0;
alter table thisdev add column accessoptions integer default 0;
alter table thisdev add column joboptions integer default 0;
alter table thisdev add column csvdays integer default 0;
alter table thisdev add column refreshdb integer not null default 0;
alter table thisdev add column hrsindec integer default 0;
alter table thisdev add column maxemployees integer default 0;
alter table thisdev add column webmaster integer default 0;
alter table thisdev add column csvdecimal integer default 1;
alter table thisdev add column defaultseq integer default -100;
alter table thisdev add column holidayregion text not null default '';
alter table thisdev add column pc integer not null default 2;
alter table thisdev add column ishost integer not null default 0;
alter table thisdev add column hostpollseconds integer not null default 120;
alter table thisdev add column hostsyncseconds integer not null default 120;
alter table thisdev add column hostpropogateseconds integer not null default 300;
alter table thisdev add column allowoverridelogin integer default 1;
alter table thisdev add column language text not null default 'english';
alter table thisdev add column softwarename text not null default '';
alter table thisdev add column customer text not null default '';
alter table thisdev add column clockdesc text not null default '';
alter table thisdev add column contactdetails text not null default '';
alter table thisdev add column softwaredata text not null default '';
alter table thisdev add column strictfpenroll integer default 0;
alter table thisdev add column isguest integer not null default 1;
-- isguest is deprecated
alter table thisdev add column mcr integer not null default 1;
alter table thisdev add column mcrdelay integer not null default 3;
alter table thisdev add column deleteperiod integer not null default 604800;

alter table thisdev add column modem integer not null default 2;
alter table thisdev add column modemtype integer not null default 260;
alter table thisdev add column modemcomport integer not null default 1;
alter table thisdev add column modemsignal integer not null default 99;
alter table thisdev add column modemmode integer not null default -1;
alter table thisdev add column modemstime integer not null default 0;
alter table thisdev add column debug integer not null default 0;

alter table thisdev add column wlanssid text not null default '';
alter table thisdev add column wlanpsk text not null default '';

alter table thisdev add column modembalance text not null default '';
alter table thisdev add column modemtime integer not null default 0;
alter table thisdev add column modembalancea text not null default '';
alter table thisdev add column modemphone text not null default '+27000000000';
alter table thisdev add column modemprovider integer not null default 0;

alter table thisdev add column smsrx integer not null default 0;
alter table thisdev add column smstx integer not null default 0;

alter table thisdev add column ntp integer not null default 0;

alter table thisdev add column connectioninterval integer not null default 0;

alter table thisdev add column lcdbroadcastline3 text not null default '';
alter table thisdev add column lcdbroadcastline4 text not null default '';
alter table thisdev add column whoamiminutes integer not null default 61;

alter table thisdev add column replicate integer not null default 0;
alter table thisdev add column replicatemaxcon integer not null default 50;
alter table thisdev add column replicatettl integer not null default 7;
alter table thisdev add column replicatetimediff integer not null default 2000;
alter table thisdev add column replicaterapidtimeout integer not null default 800;
alter table thisdev add column replicatedisablecomments integer not null default 1;
alter table thisdev add column replicatetimeonly integer not null default 0;

alter table thisdev add column fastprocessor integer not null default 0;
alter table thisdev add column fastprocessorpms integer not null default 250;
alter table thisdev add column fastprocessorqpms integer not null default 500;

update thisdev set modemphone='+27000000000' where modemphone='';

alter table thisdev add column quietconnection integer not null default 0;

alter table thisdev add column keepalivetime integer not null default 7200;
alter table thisdev add column keepaliveinterval integer not null default 75;
alter table thisdev add column keepaliveprobes integer not null default 9;

--update thisdev set internettimeserver1 = 'time-nist.symmetricom.com' where id = 1;
--update thisdev set internettimeserver4 = 'nist1-ny.ustiming.org' where id = 1;
--update thisdev set internettimeserver5 = 'nist1.aol-va.symmetricom.com' where id = 1;
-- XXX temporary
update thisdev set internettimeserver1 = 'time.nist.gov' where id = 1 and (internettimeserver1 = 'nist1-nj2.ustiming.org' or internettimeserver1 = 'nist1-pa.ustiming.org' or internettimeserver1 = 'time-nist.symmetricom.com' or internettimeserver1 = 'time-b.nist.gov');
update thisdev set internettimeserver2 = 'nist.time.nosc.us' where id = 1 and internettimeserver2 = 'time-c.timefreq.bldrdoc.gov';
-- XXX temporary

-- table model
alter table model add column portable integer not null default 0;
insert into model (id,serial,lcdwidth,lcdheight,graphics,relaycount,portable,desc) values (5, -1, 20, 4, 0, 0, 1, 'Portable Clock with 20x4 LCD 0 relays');
insert into model (id,serial,lcdwidth,lcdheight,graphics,relaycount,portable,desc) values (6, -1, 16, 2, 0, 0, 0, 'Job Clock with 16x2 LCD 0 relays (2 LED buttons)');

-- table otherdev
alter table otherdev add column desc text not null default '';
alter table otherdev add column pc integer not null default 2;
alter table otherdev add column lastsync integer not null default 0;
alter table otherdev add column mcr integer not null default 0;
alter table otherdev add column mode integer not null default 0;
alter table otherdev add column lastcomm integer not null default 0;

-- update otherdev set mcr = 0; -- set any otherdev entries that may already be 1 to 0

-- table gatewaydev
create table if not exists gatewaydev (
  serial integer not null primary key,
  ip string,
  port integer,
  resyncrqd integer,
  lastcatime integer,
  lastcstime integer,
  pc integer default 2,
  desc text not null default '',
  disabled integer not null default 0,
  synctime integer not null default 0,
  syncemp integer not null default 0
);


-- table card
alter table card add column fpsec integer not null default 1;
alter table card add column fp text not null default '';
alter table card add column fpf integer not null default 0;
alter table card add column fpl integer not null default 0;
alter table card add column fpcrc integer not null default 0;
alter table card add column enrolq integer not null default 0;
alter table card add column deleted integer not null default 0;
alter table card add column tstamp integer not null default 0;

--update card set lcn = 902, ecn = 902, scn = '0000000902' where lcn = 901 and seqid = -420 and pc = 0;	-- Show Emp Number (do this one first)
update card set lcn = 901, ecn = 901, scn = '0000000901' where lcn = 900 and seqid = -410 and pc = 0;	-- Show Emp Details

insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (900, 900, '0000000900', '', 0, 0, -180);	-- Menu
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (930, 930, '0000000930', '', 0, 0, -600);	-- Get Internet Time
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (931, 931, '0000000931', '', 0, 0, -601);	-- Set Time
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (932, 932, '0000000932', '', 0, 0, -602);	-- Set Date
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (933, 933, '0000000933', '', 0, 0, -603);	-- Set TimeZone

--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (940, 940, '0000000940', '', 0, 0, -506);	-- Set modem phone number (temporary)
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (944, 944, '0000000944', '', 0, 0, -816);	-- Self Test
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (945, 945, '0000000945', '', 0, 0, -817);	-- GSM Test
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (946, 946, '0000000946', '', 0, 0, -821);	-- GSM reset
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (947, 947, '0000000947', '', 0, 0, -820);	-- GSM toggle (1 half of GSM reset)

insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (951, 951, '0000000951', '', 0, 0, -701);	-- USB export CSV
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (959, 959, '0000000959', '', 0, 0, -702);	-- USB Run Command
-- insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (938, 938, '0000000938', '', 0, 0, -495);	-- Set Serial Number ** obsolete **
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (939, 939, '0000000939', '', 0, 0, -490);	-- Reboot
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (986, 986, '0000000986', '', 0, 0, -401);	-- Remove Employee
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (987, 987, '0000000987', '', 0, 0, -301);	-- Remove Card
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (960, 960, '0000000960', '', 0, 0, -800);	-- Application Update Clock (via Web)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (961, 961, '0000000961', '', 0, 0, -801);	-- Application Update Clock via Memory Stick
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (962, 962, '0000000962', '', 0, 0, -802);	-- Force Application Update Clock (via Web)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (963, 963, '0000000963', '', 0, 0, -803);	-- Force Application Update Clock via Memory Stick
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (965, 965, '0000000965', '', 0, 0, -805);	-- Set Application Update to use Release Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (966, 966, '0000000966', '', 0, 0, -806);	-- Set Application Update to use Beta Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (967, 967, '0000000967', '', 0, 0, -807);	-- Set Application Update to use Alpha Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (968, 968, '0000000968', '', 0, 0, -808);	-- Set Application Update to use Gamma Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (969, 969, '0000000969', '', 0, 0, -822);	-- Force rollpass db check (update password)
-- ------------------------------------------------ --
-- CARDS 970 through 979 reserved for Button-Reader --
-- ------------------------------------------------ --
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (982, 982, '0000000982', '', 0, 0, -430);	-- Promote Employee to Admin
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (983, 983, '0000000983', '', 0, 0, -431);	-- Demote Admin (Employee)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (984, 984, '0000000984', '', 0, 0, -432);	-- Promote Employee to Supervisor
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (985, 985, '0000000985', '', 0, 0, -433);	-- Demote Supervisor (Employee)
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (958, 958, '0000000958', '', 0, 0, -703);	-- USB Restore (DB)
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (991, 991, '0000000991', '', 0, 0, -10);	-- Backup Clock to USB and Internet
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (998, 998, '0000000998', '', 0, 0, -815);	-- Sync FP



-- table daughter
alter table daughter add column descf1 text not null default '';
alter table daughter add column desc1 text not null default '';
alter table daughter add column desc2 text not null default '';
alter table daughter add column desc3 text not null default '';
alter table daughter add column comportf1 integer not null default -1;
alter table daughter add column defaulttimezone integer not null default 0;
alter table daughter add column overridetimezone integer not null default 0;
alter table daughter add column timezoneoninonly integer not null default 0;
alter table daughter add column caf1 integer not null default 0;
alter table daughter add column paf1 integer not null default 0;
alter table daughter add column ca1 integer not null default 0;
alter table daughter add column pa1 integer not null default 0;
alter table daughter add column ca2 integer not null default 0;
alter table daughter add column pa2 integer not null default 0;
alter table daughter add column ca3 integer not null default 0;
alter table daughter add column pa3 integer not null default 0;
alter table daughter add column locked integer not null default 0;
alter table daughter add column defaultnoaccess integer not null default 0;
alter table daughter add column pc integer not null default 2;
alter table daughter add column online integer not null default 0;
alter table daughter add column defaultpayroll integer not null default 1;
alter table daughter add column cam1 integer not null default 0;
alter table daughter add column cam1brightness integer not null default -1;
alter table daughter add column cam1control integer not null default 0;
alter table daughter add column cam1size integer not null default 0;
alter table daughter add column fpthreshold1 integer not null default 22645;
alter table daughter add column seclevel1 integer not null default 2;
alter table daughter add column fprepeattime1 integer not null default 5;
alter table daughter add column optionsf1 integer not null default 0;
alter table daughter add column noduplicatesf1 integer not null default 1;
alter table daughter add column minfpqf1 integer not null default 0;
alter table daughter add column verifyretriesf1 integer not null default 0;

alter table daughter add column doorfeedback integer not null default 0;
alter table daughter add column doortimeoutms1 integer not null default 0;
alter table daughter add column doortimeoutms2 integer not null default 0;
alter table daughter add column doortimeoutms3 integer not null default 0;
alter table daughter add column dininvert integer not null default 0;

alter table daughter add column randomcheck integer not null default 0;
alter table daughter add column randomchecktotal integer not null default 100;
alter table daughter add column checktime integer not null default 300;
alter table daughter add column	rcrelay integer not null default 0;
alter table daughter add column	rcrelayms integer not null default 250;

alter table daughter add column jobclocklineno integer not null default 0;

-- fingerprint reader	2 (could be any serial reader - eg barcode)
alter table daughter add column comportf2 integer not null default -1;
alter table daughter add column descf2 text not null default '';
alter table daughter add column tyf2 integer not null default 0;
alter table daughter add column tdf2 integer not null default 0;
alter table daughter add column aef2 integer not null default 0;
alter table daughter add column caf2 integer not null default 0;
alter table daughter add column paf2 integer not null default 0;
alter table daughter add column inf2 integer not null default 0;
alter table daughter add column outf2 integer not null default 0;
alter table daughter add column daf2 integer not null default 0;
alter table daughter add column inrbf2 integer not null default 0;
alter table daughter add column outrbf2 integer not null default 0;
alter table daughter add column inarbf2 integer not null default 0;
alter table daughter add column outarbf2 integer not null default 0;
alter table daughter add column fpthreshold2 integer not null default 22645;
alter table daughter add column seclevel2 integer not null default 2;
alter table daughter add column fprepeattime2 integer not null default 5;
alter table daughter add column optionsf2 integer not null default 0;
alter table daughter add column noduplicatesf2 integer not null default 1;
alter table daughter add column minfpqf2 integer not null default 0;
alter table daughter add column verifyretriesf2 integer not null default 0;

update daughter set	ty1 =0 where ty1 is NULL;
update daughter set	td1 =0 where td1 is NULL;
update daughter set	ae1 =0 where ae1 is NULL;
update daughter set	ca1 =0 where ca1 is NULL;
update daughter set	pa1 =0 where pa1 is NULL;
update daughter set	in1 =0 where in1 is NULL;
update daughter set	out1 =0 where out1 is NULL;
update daughter set	da1 =0 where da1 is NULL;
update daughter set	inrb1 =0 where inrb1 is NULL;
update daughter set	outrb1 =0 where outrb1 is NULL;
update daughter set	inarb1 =0 where inarb1 is NULL;
update daughter set	outarb1 =0 where outarb1 is NULL;
update daughter set cam1 =0 where cam1 is NULL;
update daughter set fpthreshold1 = 22645 where fpthreshold1 is NULL;

update daughter set	ty2 =0 where ty2 is NULL;
update daughter set	td2 =0 where td2 is NULL;
update daughter set	ae2 =0 where ae2 is NULL;
update daughter set	ca2 =0 where ca2 is NULL;
update daughter set	pa2 =0 where pa2 is NULL;
update daughter set	in2 =0 where in2 is NULL;
update daughter set	out2 =0 where out2 is NULL;
update daughter set	da2 =0 where da2 is NULL;
update daughter set	inrb2 =0 where inrb2 is NULL;
update daughter set	outrb2 =0 where outrb2 is NULL;
update daughter set	inarb2 =0 where inarb2 is NULL;
update daughter set	outarb2 =0 where outarb2 is NULL;
update daughter set fpthreshold2 = 22645 where fpthreshold2 is NULL;

update daughter set	ty3 =0 where ty3 is NULL;
update daughter set	td3 =0 where td3 is NULL;
update daughter set	ae3 =0 where ae3 is NULL;
update daughter set	ca3 =0 where ca3 is NULL;
update daughter set	pa3 =0 where pa3 is NULL;
update daughter set	in3 =0 where in3 is NULL;
update daughter set	out3 =0 where out3 is NULL;
update daughter set	da3 =0 where da3 is NULL;
update daughter set	inrb3 =0 where inrb3 is NULL;
update daughter set	outrb3 =0 where outrb3 is NULL;
update daughter set	inarb3 =0 where inarb3 is NULL;
update daughter set	outarb3 =0 where outarb3 is NULL;

update daughter set	tyf1 =0 where tyf1 is NULL;
update daughter set	tdf1 =0 where tdf1 is NULL;
update daughter set	aef1 =0 where aef1 is NULL;
update daughter set	caf1 =0 where caf1 is NULL;
update daughter set	paf1 =0 where paf1 is NULL;
update daughter set	inf1 =0 where inf1 is NULL;
update daughter set	outf1 =0 where outf1 is NULL;
update daughter set	daf1 =0 where daf1 is NULL;
update daughter set	inrbf1 =0 where inrbf1 is NULL;
update daughter set	outrbf1 =0 where outrbf1 is NULL;
update daughter set	inarbf1 =0 where inarbf1 is NULL;
update daughter set	outarbf1 =0 where outarbf1 is NULL;

create table if not exists timezoneset (
	id integer not null primary key,
	desc text not null default '',
  pc integer not null default 2
)	;
alter table timezoneset add column deleted integer not null default 0;
alter table timezoneset add column tstamp integer not null default 0;

-- table timezone
create table if not exists timezone (
	id integer not null primary key,
	setid integer not null default 0,
	num integer not null default 1,
	desc text not null default '',
	monstart integer not null default -1,
	monend integer not null default -1,
	tuestart integer not null default -1,
	tueend integer not null default -1,
	wedstart integer not null default -1,
	wedend integer not null default -1,
	thustart integer not null default -1,
	thuend integer not null default -1,
	fristart integer not null default -1,
	friend integer not null default -1,
	satstart integer not null default -1,
	satend integer not null default -1,
	sunstart integer not null default -1,
	sunend integer not null default -1,
	pc integer not null default 0
);
alter table timezone add column setid integer not null default 0;
alter table timezone add column num integer not null default 1;
alter table timezone add column deleted integer not null default 0;
alter table timezone add column tstamp integer not null default 0;
insert into timezoneset (id,desc) select id,id from timezone where setid=0;
update timezone set setid = id where setid = 0;


-- table empaccess
create table if not exists empaccess (
	id integer not null primary key,
	en text not null default '',
	serial integer not null default 0,
	access integer not null default 1,
	accessout integer not null default 1,
  payroll integer not null default -1,	
	timezoneid integer not null default 0,	
	pc integer not null default 0,
	pathing integer not null default -1,
	lockdoor integer not null default 0,
	opendoor integer not null default 1
);
create index if not exists empaccess_enkey on empaccess(en,access,timezoneid);
alter table empaccess add column deleted integer not null default 0;
alter table empaccess add column tstamp integer not null default 0;

delete from schedule where id = 310;
delete from schedule where id = 311;

insert into schedule (id,_nextdue,seqid,seconds,mon,tue,wed,thu,fri,sat,sun,dserial,si1,si2,ss1,ss2,ss3,ss4,desc) values (312, 1, -819, 0, 1, 1, 1, 1, 1, 1, 1, 0,       0, 0, 'Removing', 'Deleted Entries',  '', '', 'Delete DB Entries');


alter table empaccess add column pathing integer not null default -1;
alter table empaccess add column lockdoor integer not null default 0;
alter table empaccess add column opendoor integer not null default -1;
alter table empaccess add column accessout integer not null default 1;
alter table empaccess add column payroll integer not null default -1;

-- =========================================================================
-- Table: sms
--	id integer 
--	phone               -- phone number to send message to or phone number message received from
--	message             -- text to send, 160 chars 
---	status              -- 1 = waiting, 2 = sending, 3 = sent, 4 = send failed,  8 = received, 9 = received and processed
--	sendat              -- outgoing sms, time to send at. use 1 for "now"
--	senttime            -- outgoing sms - time sent
--	recvtime            -- incoming sms, time received
--	tstamp				-- Timestamp set each time a row is added/changed
-- 	pc                  -- record owner.
--	deleted							-- Time at which the entry was deleted
-- ----------------------------------------------------
create table if not exists sms (
	id integer not null primary key,
	phone text not null default '',
	message text not null default '',
	status integer not null default 0,
	sendat integer not null default 0,
	senttime integer not null default 0,
	recvtime integer not null default 0,
	tstamp integer not null default 0,
	pc integer not null default 2,
	deleted integer not null default 0
);

-- =========================================================================
-- Table: empmessage
-- ----------------------------------------------------
--	messageguid 				-- Unique string for message
--	fromemp             -- Employee setting the message
--	toemp             	-- Employee to receive message
--	message             -- Message
--	dateexp             -- Message expiry date
--	allowaccess         -- 0 = No, 1 = Yes
--	allowclocking       -- 0 = No, 1 = Yes
--	datevisible					-- Date from which to display message to user
--	acknowledged				-- 0 = not acknowledged, 1 = acknowledged
--	tstamp							-- Timestamp set each time a row is added/changed
-- 	pc                  -- record owner.
--	deleted							-- Time at which the entry was deleted
-- ----------------------------------------------------
create table if not exists empmessage (
	messageguid text not null primary key,
	fromemp text not null default '',
	toemp text not null default '',
	message text not null default '', 
	dateexp integer not null default 0, 
	allowaccess integer not null default 0, 
	allowclocking integer not null default 0, 
	datevisible integer not null default 0,
	acknowledged integer not null default 0,
	tstamp integer not null default 0, 
	pc integer not null default 2,
	deleted integer not null default 0
);

-- =========================================================================
-- Table: empmessagelog
-- ----------------------------------------------------
--	id integer 					-- key
--	messageguid         -- guid of emp message
--	datetime            -- Date, time of log message
--	action              -- 1 = add, 2 = delete, 3 = viewed, 4 = acknowledged
-- 	pc                  -- record owner.
--	tstamp							-- Timestamp set each time a row is added/changed
--	deleted							-- Time at which the entry was deleted
-- ----------------------------------------------------
create table if not exists empmessagelog (
	id integer not null primary key,
	messageguid text not null default '',
	datetime integer not null default 0,
	action integer not null default 0, 
	pc integer not null default 2, 
	tstamp integer not null default 0, 
	deleted integer not null default 0 
);

-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- This field must be manually changed when database structure changed. Changes should also be documented in CS Time Clock SDK document.
-- Be sure to set the same value in Fox_Database_Script.Sql and alter.Sq
-- from  version 3250 (firmware 2.04 and 1.26) this is no longer linked to the Firmware version directly.
-- -------------------------------------------------------------------------------------------------------------------------------------------------
update _info set dbversion = 3272;
-- -------------------------------------------------------------------------------------------------------------------------------------------------
