#! /bin/sh

usage() {
  echo ""
  echo "-------------------------------------------------------------------"
	echo Usage: "$0" \<To address\> \<Subject\> \<Content\> \<Attachment\>
	echo ""
	echo " fast : The clock will not check for a modem."
	echo " slow : The clock will check whether a modem is attached on startup."
  echo "-------------------------------------------------------------------"
	echo ""
	exit 1
}

if [ $# != 4 ]
then
	usage
	exit 1
fi

IP=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "select smtpip from thisdev;")
PORT=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "select smtpport from thisdev;")
USER=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "select smtpuser from thisdev;")
PASS=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "select smtppass from thisdev;")
SERIAL=$(cat /var/local/data/SerialNumber.txt)
DASHU=1

if [ -z "$IP" ]
then
 exit 1
fi

if [ $PORT -eq 0 ]
then
 PORT=25
fi

if [ -z "$" ]
then
 DASHU=0
fi

DATE=$(date +%s)
BOUNDARY=$SERIAL$DATE$RANDOM

touch /tmp/email

echo "MIME-Version: 1.0" > /tmp/email
echo "Content-Type: multipart/mixed;" >> /tmp/email
echo "  boundary=\"$BOUNDARY\"" >> /tmp/email
echo "From: \"CS$SERIAL\" <noreply@capesoft.com>" >> /tmp/email
echo "To: <$1>" >> /tmp/email
echo Subject: $2 >> /tmp/email

echo '' >> /tmp/email
echo "--$BOUNDARY" >> /tmp/email

echo "" >> /tmp/email
echo "$3" >> /tmp/email
echo "" >> /tmp/email

if [ "$4" != "0" ]
then
	if [ -e "$4" ]
	then
		cp $4 /tmp
		RAWFILE=$(basename $4)
		gzip /tmp/$RAWFILE
		echo '' >> /tmp/email
		echo "--$BOUNDARY" >> /tmp/email
		echo "Content-Type: application/x-gzip" >> /tmp/email
		echo "Content-Transfer-Encoding: base64" >> /tmp/email
		echo "Content-Disposition: attachment;" >> /tmp/email
		echo "  filename=$RAWFILE.gz" >> /tmp/email
		echo "" >> /tmp/email
		/usr/bin/base64 /tmp/$RAWFILE.gz >> /tmp/email
		rm /tmp/$RAWFILE.gz
	fi
fi

echo "--$BOUNDARY--" >> /tmp/email

if [ $DASHU -eq 0 ]
then
	/usr/bin/curl --mail-from noreply@capesoft.com --mail-rcpt $1 -T /tmp/email --url smtp://$IP:$PORT -s
else
	/usr/bin/curl --mail-from noreply@capesoft.com --mail-rcpt $1 -T /tmp/email -u $USER:$PASS --url smtp://$IP:$PORT -s
fi

exit $?
