#! /bin/sh

# Rob's wifi setup

usage() {
  echo ""
  echo "-------------------------------------------------------------------"
	echo Usage: "$0" \<SSID\> \<password\>
	echo "Script to set the WIFI access point name and password (passkey)."
	echo "This script will set the wpa_supplicant.conf file and the db values."
	echo "Restart the clock for the changes to take effect."
	echo "WLAN SSID."
	echo "WLAN password."
  echo "-------------------------------------------------------------------"
	echo ""
	exit 1
}

if [ $# != 2 ]
then
	usage
fi

# update db
/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set wlanssid='$1', wlanpsk='$2' where id = 1;"

# update /etc/wpa_supplicant.conf
sed -i "2 s/=.*/=\"$1\"/" /etc/wpa_supplicant.conf
sed -i "5 s/=.*/=\"$2\"/" /etc/wpa_supplicant.conf

echo " "
echo "-------------------"
echo "Thisdev wifi fields"
echo " "
/usr/local/bin/sqlite3shell -header /var/local/data/capeclock.db "select wlanssid, wlanpsk from thisdev where id = 1;"
echo "-------------------"
echo " "
echo "/etc/wpa_supplicant.conf"
echo " "
cat /etc/wpa_supplicant.conf
echo "-------------------"
echo " "
echo "WLAN configured."
echo "Please restart the clock for the changes to take effect."

exit 0
