#! /bin/bash

if [ $# != 1 ]
then
	echo "Usage: $0 <clocktype>"
	exit 1
fi

for FILE in /etc/init.d/welcome-message /etc/init.d/safe-message /etc/init.d/reboot-message /etc/init.d/clock /etc/init.d/detectbigflash /usr/local/bin/formatusb.sh /usr/local/bin/stopclock /usr/local/bin/usbrestore.sh
do
	if [ $1 -eq 0 ]	# TIMECLOCK
	then
		sed -i '1N;$!N;s/^#TIMECLOCK \(.*\)\n#JOBCLOCK \(.*\)\n.*/#TIMECLOCK \1\n#JOBCLOCK \2\n\1/;P;D' $FILE
	fi
	if [ $1 -eq 1 ] # JOBCLOCK
	then
		sed -i '1N;$!N;s/^#TIMECLOCK \(.*\)\n#JOBCLOCK \(.*\)\n.*/#TIMECLOCK \1\n#JOBCLOCK \2\n\2/;P;D' $FILE
	fi
done

exit 0
