#! /bin/sh

MINUTES=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "select whoamiminutes from thisdev;")
if [ $? -ne 0 ]
then
	echo "Could not read whoamiminutes from database."
	exit 1
fi

if [ $MINUTES -lt 60 ]
then
	FOUND=$(sed -n "s/^\*\/$MINUTES\t\*\t\*\t\*\t\*\t/ /p" /etc/cron.d/ipnotifyc | wc -l)
	if [ $FOUND -eq 1 ]
	then
	 exit 0
	else
		sed -i "s/^[0-9\*][0-9\t\/\*]*/\*\/$MINUTES\t\*\t\*\t\*\t\*\t/" /etc/cron.d/ipnotifyc
	fi
elif [ $MINUTES -ge 60 ] && [ $MINUTES -lt 1440 ]
then
	HOURS=$(($MINUTES / 60))
	FOUND=$(sed -n "s/^[0-9]*\t\*\/$HOURS\t\*\t\*\t\*\t/123 /p" /etc/cron.d/ipnotifyc | wc -l)
	if [ $FOUND -eq 1 ]
	then
		exit 0
	else
		MINUTE=$(($RANDOM % 55))
	 	sed -i "s/^[0-9\*][0-9\t\/\*]*/$MINUTE\t\*\/$HOURS\t\*\t\*\t\*\t/" /etc/cron.d/ipnotifyc
	fi
else
	exit 1
fi
