#!/bin/sh
CURRENT_DB=/var/local/data/capeclock.db
SQLITE_SHELL=/usr/local/bin/sqlite3shell
VARLOG=/var/sqllog
NOW=$(date +"%Y_%m_%d_%H_%M_%S")
SERIAL=$(cat /var/local/data/SerialNumber.txt)
BACKUP_FILE="/var/local/data/Backup.txt"
BACKUP_DB="/mnt/6/capeclock.db.$SERIAL.$NOW.bak"
BACKUP_DB_GZ=$BACKUP_DB.gz
BACKUP_SITE=$(cat $BACKUP_FILE)
#limitations on curl
CURL_MAX=600
CURL_CON=40
#CURL_RETRY=2

# copy database

/usr/local/bin/csapi.sh 20 autobackup.sh &

#/usr/local/bin/stopclock
#cp $CURRENT_DB $BACKUP_DB
#if [ "$1" != "--nostart" ]; then
#	/usr/local/bin/startclock
#fi

/usr/local/bin/dbbackup $BACKUP_DB
if [ "$?" -ne 0 ]
	then
	echo "AUTOBACKUP: [$NOW] Could not backup DB" > /dev/kmsg
	exit 1
fi

if [ "$1" = "--nostart" ]
	then
	/usr/local/bin/stopclock
fi

# zip database
gzip $BACKUP_DB

# POST database to web server
if [ "$BACKUP_SITE" != "" ]; then
	echo "curl -F backup=@$BACKUP_DB_GZ $BACKUP_SITE"
	curl --connect-timeout $CURL_CON --max-time $CURL_MAX -F backup=@$BACKUP_DB_GZ $BACKUP_SITE
else
	echo "Backup not uploaded: Backup site not set in $BACKUP_FILE"
fi

#remove backups older than 90 days
#find /var/sqllog/capeclock.db.*.bak.gz -mtime +90 -exec rm {} \;
find /mnt/6/capeclock.db.*.bak.gz -mtime +90 -exec rm {} \;

# remove all log files older than 90 days
find /var/sqllog/*.sql -mtime +90 -exec rm {} \;

# remove all modem log files older than 90 days
find /var/sqllog/modem* -mtime +90 -exec rm {} \;

# remove all net log files older than 90 days
find /var/sqllog/net* -mtime +90 -exec rm {} \;

#/usr/local/bin/csapi.sh 21 autobackup.sh &
exit 0
