#! /bin/sh

usage() {
  echo ""
  echo "-------------------------------------------------------------------"
#	echo Usage: "$0" \<startup speed\> \<fpr\> \<serial number\>
	echo Usage: "$0 \<startup speed\> \<serial number\> [P|J|T]"
	echo "Startup speed can be 'fast' or 'slow'."
	echo " fast : The clock will not check for a modem."
	echo " slow : The clock will check whether a modem is attached on startup."
#	echo "Set fpr to configure fingerprint reader"
#	echo " -    : None"
#	echo " f    : Futronix reader"
#	echo " l    : Lumidigm reader"
	echo "* Assume Mobile provider is Vodacom for now. *"
	echo " P : Portable clock [optional]"
	echo " J : Job clock [optional]"
	echo " T : Tool clock [optional]"
  echo "-------------------------------------------------------------------"
	echo ""
	exit 1
}

MODEMPROVIDER=1

if [ $# != 2 ]
then
	if [ $# == 3 ]
	then
		echo "PORTABLE / JOBCLOCK / TOOLCLOCK ?"
	else
		usage
	fi
fi

PORTABLE=0
JOBCLOCK=0
if [ $# == 3 ]
then
	if [[ $3 == "P" || $3 == "p" ]]
	then
		echo "This is a portable device!"
		echo "Are you sure that this is a portable device? [yes][no]"
		read -t 10 ANSWER
		if [[ $? == 0 && "$ANSWER" == "yes" ]]
		then
			PORTABLE=1
		else
			echo "Exit."
			usage
		fi
	elif [[ $3 == "J" || $3 == "j" ]]
	then
		echo "This is a JOB CLOCK!"
		echo "Are you sure that this is a JOB CLOCK? [yes][no]"
		read -t 10 ANSWER
		if [[ $? == 0 && "$ANSWER" == "yes" ]]
		then
			JOBCLOCK=1
		else
			echo "Exit."
			usage
		fi
	elif [[ $3 == "T" || $3 == "t" ]]
	then
		echo "This is a TOOL CLOCK!"
		echo "Are you sure that this is a TOOL CLOCK? [yes][no]"
		read -t 10 ANSWER
		if [[ $? == 0 && "$ANSWER" == "yes" ]]
		then
			JOBCLOCK=2
		else
			echo "Exit."
			usage
		fi
	else
		echo "Invalid input."
		usage
	fi
fi

if [[ "$1" == "fast" || "$1" == "slow" ]]
then
	echo "Modem value is valid"
else
	usage
fi

#if [[ "$2" == "-" || "$2" == "f" || "$2" == "l" ]]
#then
#	echo "FPR value is valid"
#else
#	usage
#fi

if [[ $2 =~ ^[0-9]* ]] && [[ $2 -gt 0 ]];
then
	echo "Serial number is an integer"
else
	usage
fi

# If PORTABLE then toggle WDT!
if [ $PORTABLE == 1 ] || [ $JOBCLOCK == 1 ] || [ $JOBCLOCK == 2 ]
then
	WDT=94
	WDTP=C30
	echo $WDT > /sys/class/gpio/export
	echo out > /sys/class/gpio/pio$WDTP/direction
	echo 1 > /sys/class/gpio/pio$WDTP/value
	echo 0 > /sys/class/gpio/pio$WDTP/value
fi

echo ""
echo " ----- Setting up Clock ----- "
echo ""

# Get the USB drive ready
echo " Formatting USB drive"
/usr/local/bin/formatusb.sh -detect

while [ $(pidof /usr/local/bin/formatusb.sh) ]
do
	sleep 1
done

# Set the MAC address (and restart networking daemon)
/usr/local/bin/mac.sh $2
/etc/init.d/networking restart
sleep 4

# Set the time
echo "Setting the time"
/usr/local/bin/csrdate -v time.nist.gov
sleep 4

echo " Detect big flash init"
/usr/local/bin/dbf.sh usb

while [ ! -e "/var/local/data/capeclock.db" ]
do
	sleep 1
done

# Set serial number
echo Setting serial to "$2"
#/usr/local/bin/setserial.sh "$3"
echo "$2" > /var/local/data/SerialNumber.txt
echo "$2" > /var/sdcard/data/SerialNumber.txt
hostname CSTC$2
echo "CSTC$2" > /etc/hostname
/etc/init.d/samba restart

# Set up fast or slow start up
if [[ $1 == "fast" ]]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set modem = 2 where id  = 1;"
fi

if [[ $1 == "slow" ]]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set modem = 0, modemprovider = $MODEMPROVIDER where id  = 1;"
	/usr/local/bin/mconf
fi

# If portable set daughterinfo
if [ $PORTABLE == 1 ]
then
	DSERIAL=$(($2 - 1000))
	ADDRDT=$(date +%s)
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "delete from _daughterinfo;"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "insert into _daughterinfo (serial, addr, addrdt, rcode) VALUES ($DSERIAL, 2, $ADDRDT, 1);"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "insert into chore (id, olddatatime, checkolddatainterval) VALUES (2, 0, 150);"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set defaultmodel=5 where id=1;"
elif  [ $JOBCLOCK == 1 ]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set defaultmodel=6 where id=1;"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set joboptions=1 where id=1;"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "insert into chore (id, olddatatime, checkolddatainterval) VALUES (2, 0, 150);"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set mcr=0 where id=1;"
elif  [ $JOBCLOCK == 2 ]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set defaultmodel=7 where id=1;"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "insert into chore (id, olddatatime, checkolddatainterval) VALUES (2, 0, 150);"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set mcr=0 where id=1;"
else
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set defaultmodel=3 where id=1;"
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "delete from chore where id=2;"
fi

/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "delete from daughter;"

#/usr/local/bin/sqlite3shell /var/local/data/capeclock.db < /usr/local/bin/alter.sql
/usr/local/bin/db_alter --quiet

#if [ $PORTABLE == 1 ]
#then
#	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set lowpowerenabled=1 where id=1;"
#fi

MENUCAT=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db 'select * from sqlite_master where name="menucat_catkey";' | grep "language,model,catno" | wc -l)
MENUITEM=$(/usr/local/bin/sqlite3shell /var/local/data/capeclock.db 'select * from sqlite_master where name="menuitem_catitemkey";' | grep "language,model,catno,itemno" | wc -l)

/usr/local/bin/adjustscripts.sh $JOBCLOCK

echo ""
echo " ----- Done ----- "
echo ""

echo ""
echo " ----- Summary ----- "
echo ""
echo "Modem setting:"
/usr/local/bin/sqlite3shell -header /var/local/data/capeclock.db "select modem, modemprovider from thisdev where id  = 1;"
echo "Serial:"
cat /var/local/data/SerialNumber.txt
if [ $PORTABLE == 1 ]
then
	echo "PORTABLE:"
	/usr/local/bin/sqlite3shell -header /var/local/data/capeclock.db "select serial, addr, addrdt, rcode from _daughterinfo;"
	/usr/local/bin/sqlite3shell -header /var/local/data/capeclock.db "select * from chore where id = 2;"
fi
echo "Clock default model:"
echo "3 = Normal clock, 5 = Portable clock, 6 = Job clock, 7 = Tool clock"
/usr/local/bin/sqlite3shell -header /var/local/data/capeclock.db "select defaultmodel from thisdev where id = 1;"
echo ""
if [ $MENUCAT -eq 1 ]
then
	echo "MENUCAT index is good."
else
	echo "MENUCAT index ERROR!!!"
fi
if [ $MENUITEM -eq 1 ]
then
	echo "MENUITEM index is good."
else
	echo "MENUITEM index ERROR!!!"
fi
echo ""
echo " ------------------- "
echo ""

sleep 2

/usr/local/bin/csapi.sh 140 setup.sh &

sleep 2
/usr/local/bin/updateclock
if [ $? -eq 1 ]
then
	echo "No updates so we are going to start the clock"
	/usr/local/bin/startclock
elif [ $? -ne 0 ]
then
	echo "There was an error updating the clock. Starting the clock now."
	/usr/local/bin/startclock
fi

exit 0
