#!/bin/sh

# Terminal colors
NORMAL='\033[0m'
GOOD='\033[32;01m'
WARN='\033[33;01m'
BAD='\033[31;01m'
BRACKET='\033[34;01m'

# Terminal cursor positions.
# It's tempting to use absolute column positions (Esc [ n G sequences), but
# some terminal emulators can't handle them so let's use newline followed by
# relative up and right movement instead.
OKPOS='\n\033[2A\033[72C'
FAILPOS='\n\033[2A\033[71C'
INFOPOS='\n\033[A\033[4C'

# drive mount points
MNTFLASH='/var/sdcard'
USBFLASH='/mnt/3/local'
USBDRIVE1='/mnt/3'
USBDRIVE2='/mnt/4'
USBDRIVE3='/mnt/5'
USBDRIVE4='/mnt/6'
MNTLOG='/var/sdcardlog'
USBLOG='/mnt/5'
USELOG='/var/sqllog'
# ---------------------------------------------------------------------------------------
information() {
	echo -e "${INFOPOS}${GOOD}+${NORMAL} $*"
}
# ---------------------------------------------------------------------------------------
begin() {
	echo -e " ${GOOD}*${NORMAL} $*... "
}
# ----------------------------------------------------------------------end does not exit.
end() {
	if [ "$1" = 0 ]; then
		echo -e "${OKPOS}${BRACKET}[ ${GOOD}ok${BRACKET} ]${NORMAL}"
	else
		shift
		if [ -n "$1" ]; then
			echo -e "${INFOPOS}${BAD}!${NORMAL} $*"
		fi
		echo -e "${FAILPOS}${BRACKET}[ ${BAD}fail${BRACKET} ]${NORMAL}"
	fi
}
#---------------------------------------------------------------------------------------------------
mount_data(){
  mount -t ext4 $DISKAT1 $USBDRIVE1 
  mount -t ext4 $DISKAT2 $USBDRIVE2  
  mount -t ext4 $DISKAT3 $USBDRIVE3  
  mount -t ext4 $DISKAT4 $USBDRIVE4  
}	
#---------------------------------------------------------------------------------------------------
propogate_diskat(){
	if [ "$DISKAT1" = "/dev/sda1" ];
	then
		DISKAT2="/dev/sda2"
		DISKAT3="/dev/sda3"
		DISKAT4="/dev/sda4"
	else
		if [ "$DISKAT1" = "/dev/sdb1" ];
		then
			DISKAT2="/dev/sdb2"
			DISKAT3="/dev/sdb3"
			DISKAT4="/dev/sdb4"
		fi	
	fi
}
# ---------------------------------------------------------------------------------------
find_linux(){
	STORAGEAT=""
	result=`fdisk -l | grep Linux | grep /dev/sda1`
	if [ -n "$result" ];
	then
		STORAGEAT="/dev/sda"
		DISKAT1="/dev/sda1"
		propogate_diskat
		information "Linux USB drive detected on $STORAGEAT"
		return 0
	else
		result=`fdisk -l | grep Linux | grep /dev/sdb1`
		if [ -n "$result" ];
		then
			STORAGEAT="/dev/sdb"
			DISKAT1="/dev/sdb1"
			propogate_diskat
			information "Linux USB drive detected on $STORAGEAT"
			return 0
		fi
	fi
	information "No Linux USB drive detected"
	return 1
}
#---------------------------------------------------------------------------------------------------
find_win95 (){
  begin "Checking for data on : mount -t $1 $2 $3 /dev/sda1 $USBDRIVE1" 
	mount -t $1 $2 $3 /dev/sda1 $USBDRIVE1 
	if [ "$?" -eq "0" ]; 
	then
		STORAGEAT="/dev/sda"
		DISKAT1="/dev/sda1"
		end 0
		information "FAT 32 USB drive detected on $STORAGEAT"
		umount $USBDRIVE1
		return 0
	else
		end 1
	fi
	begin "Checking for data on : mount -t $1 $2 $3 /dev/sdb1 $USBDRIVE1" 
	mount -t $1 $2 $3 /dev/sdb1 $USBDRIVE1  
	if [ "$?" -eq "0" ]; 
	then
		STORAGEAT="/dev/sdb"
		DISKAT1="/dev/sdb1"
		end 0
		information "FAT 32 USB drive detected on $STORAGEAT"
		umount $USBDRIVE1
		return 0
	else
		end 1
	fi	
	return 1
}	
#---------------------------------------------------------------------------------------------------
unmount_all(){
	result=` mount | grep $USBDRIVE1`
	if [ -n "$result" ];
	then
		umount $USBDRIVE1 
	fi	
	result=` mount | grep $USBDRIVE2`
	if [ -n "$result" ];
	then
		umount $USBDRIVE2 
	fi	
	result=` mount | grep $USBDRIVE3`
	if [ -n "$result" ];
	then
		umount $USBDRIVE3 
	fi		
	result=` mount | grep $USBDRIVE4`
	if [ -n "$result" ];
	then
		umount $USBDRIVE4 
	fi		
}
#---------------------------------------------------------------------------------------------------
format(){
  /usr/local/bin/sendchild "Starting Clock" "Formatting" $DISKAT1 ""
  echo formatting usb drive $STORAGEAT :: $DISKAT1 

	fdisk $STORAGEAT < /usr/local/bin/sda.in 
	propogate_diskat
	mke2fs -t ext4 $DISKAT1 
	mke2fs -t ext4 $DISKAT2
	mke2fs -t ext4 $DISKAT3
	mke2fs -t ext4 $DISKAT4
	sync
}
# ---------------------------------------------------------------------------------------
set_usb_flash_link(){
	information "remapping var/local, using $USBFLASH" 
	if [ -L /var/local ];
	then
		rm /var/local 
	fi	
	ln -s $USBFLASH /var/local 
	chmod -R a+rwx /var/local/* 
	
  information "remapping $USELOG using $USBLOG"	
	if [ -L $USELOG ];
	then
		rm $USELOG
	fi	
	ln -s $USBLOG $USELOG 
	chmod -R a+rwx $USELOG/* 
	sync
}
#---------------------------------------------------------------------------------------------------
copy_to_usb_flash(){
	# move data files to usb flash, and remap flash folder
	begin "Copying data from $MNTFLASH to $USBFLASH" 
	if [ ! -d $USBFLASH ];
	then
		mkdir $USBFLASH
	fi	
	cp -a $MNTFLASH/* $USBFLASH
	if [ "$?" -eq "0" ]; 
	then
		set_usb_flash_link
		end 0
		return 0
	else
		end 1
		return 1
	fi
}
#---------------------------------------------------------------------------------------------------
# maincode
#---------------------------------------------------------------------------------------------------
	# stop programs
	information "formatusb.sh : Formatting USB Thumbdrive. All data WILL BE LOST"	
	/etc/init.d/clock stop
	unmount_all

  if [ "$1" = "-detect" ];
	then
		find_linux
		if [ "$?" -eq "0" ]; 
		then
			information "LINUX partition found, attempting reformat"	
			propogate_diskat
		else
			find_win95 vfat -o umask=0000  
			if [ "$?" -eq "0" ]; 
			then
				information "FAT partition found, attempting reformat"
			else
				information "No USB Drive found"
				exit 1
			fi
		fi
	fi

	if [ "$1" = "/dev/sda" ];
	then
		result=`fdisk -l | grep Linux | grep /dev/sda`
		if [ -n "$result" ];
		then
			STORAGEAT="/dev/sda"
			DISKAT1="/dev/sda1"
		else
			information "USB Drive /dev/sda not found"
			exit 1
		fi
	fi

	if [ "$1" = "/dev/sdb" ];
	then
		result=`fdisk -l | grep Linux | grep /dev/sdb`
		if [ -n "$result" ];
		then
			STORAGEAT="/dev/sdb"
			DISKAT1="/dev/sdb1"
		else
			information "USB Drive /dev/sdb not found"
			exit 1
		fi
	fi
	
  if [ "$1" = "" ];
	then
	  information "Missing device parameter"
		information "Use /dev/sda or -detect to autodetect USB drive"
		exit 1
	fi	
		
	format
	mount_data

	mkdir $USBDRIVE1/local
	chmod 0777 $USBDRIVE1/local
	mkdir $USBDRIVE1/local/data
	mkdir $USBDRIVE1/local/updates
	mkdir $USBDRIVE1/local/www
  chmod 0777 $USBDRIVE1/local/data
	chmod 0777 $USBDRIVE1/local/updates
	chmod 0777 $USBDRIVE1/local/www
	
	set_usb_flash_link
	copy_to_usb_flash
	exit 0
	
	
	
