#!/bin/sh

# setip.sh 192.168.2 121 202
# parameters;
# 1 (192.168.2) is the subnet triplet
# 2 121 is the ip address of this machine on this subnet
# 3 202 is the gateway address on this subnet

echo setip.sh [triplet] [ip] [gateway]
echo Example Usage: setip.sh 192.168.2 100 202 
#
if [ -r "/etc/conf.d/net.eth0" ]; then
  # Fox LX100
	sed -i "s/IP=".*"/IP=\"$1\.$2\"/;
	s/NETMASK=".*"/NETMASK=\"255.255.255.0\"/;
	s/BROADCAST=".*"/BROADCAST=\"$1\.255\"/;
	s/GATEWAY=".*"/GATEWAY=\"$1\.$3\"/" /etc/conf.d/net.eth0
	echo /etc/conf.d/net.eth0 has been updated to
	echo IP=\"$1\.$2\"
	echo NETMASK=\"255.255.255.0\"
	echo BROADCAST=\"$1\.255\"
	echo GATEWAY=\"$1\.$3\" 
	echo ""
	echo "You can now run: /etc/init.d/net.eth0 restart"
else
  # Fox G20 running Debian
	sed -i "s/address.*/address $1\.$2/;
	s/netmask.*/netmask 255.255.255.0/;
	s/gateway.*/gateway $1\.$3/" /etc/network/interfaces
	echo /etc/network/interfaces has been updated to
	echo address \"$1\.$2\"
	echo netmask \"255.255.255.0\"
	echo gateway \"$1\.$3\" 
	echo ""
	#echo "You can now run: /etc/init.d/net.eth0 restart"
fi

