#!/bin/sh
CURRENT_DB=/var/local/data/capeclock.db
SQLITE_SHELL=/usr/local/bin/sqlite3shell
VARLOG=/var/sqllog
NOW=$(date +"%Y_%m_%d_%H_%M_%S")
SERIAL=$(cat /var/local/data/SerialNumber.txt)
BACKUP_FILE="/var/local/data/Backup.txt"
BACKUP_DB="/mnt/6/capeclock.db.$SERIAL.$NOW.bak"
BACKUP_DB_GZ=$BACKUP_DB.gz
BACKUP_SITE=$(cat $BACKUP_FILE)

# copy database 

/usr/local/bin/csapi.sh 20 autobackup.sh

/usr/local/bin/stopclock
cp $CURRENT_DB $BACKUP_DB
if [ "$1" != "--nostart" ]; then
	/usr/local/bin/startclock 
fi	

# zip database
gzip $BACKUP_DB

# POST database to web server
if [ "$BACKUP_SITE" != "" ]; then
	echo "curl -F backup=@$BACKUP_DB_GZ $BACKUP_SITE"
	curl -F backup=@$BACKUP_DB_GZ $BACKUP_SITE
else
	echo "Backup not uploaded: Backup site not set in $BACKUP_FILE"
fi	

#remove backups older than 90 days
find /var/sqllog/capeclock.db.*.bak.gz -mtime +90 -exec rm {} \;

# remove all log files older than 90 days
find /var/sqllog/*.sql -mtime +90 -exec rm {} \;



