#!/bin/sh
# event number is passed as parameter 1
# suggested event numbers;
# 20	Backup
# 30	BundyScript (ie keypad or scheduled)
# 40 	Firmware Update
# 60	Manual (not used on the clock)
# 100	Rebooting
# 120	Shutting Down
# 150   Started
#
# API_SITE=http://api.cstimeclocks.com/ping
API_SITE=http://api.cstimeclocks.com/ping
CLOCK_BUILD_NUMBER=2030
CLOCK_VERSION=2.03
HOSTNAME=$(hostname)
SERIAL=$(cat /var/local/data/SerialNumber.txt)
UPDATETYPE=$(cat /var/local/data/update_type)
DATE=$(date)
BACKUP_FILE="/var/local/data/Backup.txt"
BACKUP_SITE=$(cat $BACKUP_FILE)
DMESG=/tmp/dmsg.txt
MOUNT=/tmp/mount.txt
NETSTAT=/tmp/netstat.txt
PS=/tmp/ps.txt
LS=/tmp/ls.txt
DF=/tmp/df.txt
TOP=/tmp/top.txt
IFCONFIG=/tmp/ifconfig.txt
FDISK=/tmp/fdisk.txt

# gather various current states
dmesg | tail -n 200 > $DMESG
mount > $MOUNT
ps aux > $PS
ls -l /var/local/data > $LS
df > $DF
top -n 1 -b > $TOP
ifconfig -a > $IFCONFIG
fdisk -l > $FDISK
netstat > $NETSTAT
gzip -f $DMESG
gzip -f $MOUNT
gzip -f $PS
gzip -f $LS
gzip -f $DF
gzip -f $TOP
gzip -f $IFCONFIG
gzip -f $FDISK
gzip -f $NETSTAT
# send to monitoring server
curl -F serial=$SERIAL -F eventid=$1 -F desc=$2 -F hostname=$HOSTNAME -F updatetype=$UPDATETYPE -F version=$CLOCK_VERSION -F date="$DATE" -F backupsite=$BACKUP_SITE -F dmesg=@$DMESG.gz -F mount=@$MOUNT.gz -F ls=@$LS.gz -F ps=@$PS.gz -F df=@$DF.gz -F top=@$TOP.gz -F fdisk=@$FDISK.gz -F ifconfig=@$IFCONFIG.gz -F netstat=@$NETSTAT.gz $API_SITE
