#!/bin/sh

# -----------------------------------------------------
# this script restores the database from a USB Memory Stick
# -----------------------------------------------------

# ---------------------------------------------------------------------------------------
# Terminal colors
NORMAL='\033[0m'
GOOD='\033[32;01m'
WARN='\033[33;01m'
BAD='\033[31;01m'
BRACKET='\033[34;01m'
SERIALNUMBER=${SERIALNUMBER-`cat /var/local/data/SerialNumber.txt`}
LOG=/mnt/1/capeclock$SERIALNUMBER.restore.log

# ---------------------------------------------------------------------------------------
msg() {
	echo -e "$*" >> $LOG
	echo -e "${GOOD}USB Restore: ${NORMAL} $*" 
}

# ---------------------------------------------------------------------------------------
msg_error() {
	echo -e "$*" >> $LOG
	echo -e "${BAD}USB Restore Error: ${NORMAL} $*"
	echo "[CSTC] usbrestore.sh USB Restore Error: $*" > /dev/kmsg	
}

unmountusb() {
	msg "Unmounting usb device on /mnt/1"
	umount /mnt/1 > /dev/null 2>&1
}

# ---------------------------------------------------------------------------------------
exit_okay() {
	unmountusb
	msg "Exiting Okay. Return code: 0"
	exit 0
}

# ---------------------------------------------------------------------------------------
exit_fail() {
	msg_error "Exiting with error code: $1"
	unmountusb
	exit $1
}

# ---------------------------------------------------------------------------------------
# ---------------------------------------------------------------------------------------

RUN_FROM=/var/tmp
SCRIPT_NAME=`cat /proc/$$/status | sed -n 's/^Name://p' | cut -b 2-`
echo -e "${GOOD}================ $SCRIPT_NAME (`cat /proc/$$/cmdline`)================${NORMAL}"
#readlink /proc/$$/exe | grep $RUN_FROM
cat /proc/$$/cmdline | grep $RUN_FROM
if [ $? -ne 0 ]; then         
	msg "Copying script from $0 to $RUN_FROM"
	mkdir -p $RUN_FROM
	cp -f $0 $RUN_FROM
	cd $RUN_FROM
	msg "About to run: $RUN_FROM/$SCRIPT_NAME $*"
	exec $RUN_FROM/$SCRIPT_NAME $*
	#$RUN_FROM/$SCRIPT_NAME $* &
	msg_error "Should never get here [1]"
	exit 0
fi

echo "-------------------------------------------------------------------------------------------------------"


msg "Running the real USB Restore"
/usr/local/bin/sendchild "USB Restore" "Starting" "" ""

#IMPORT_DB=/mnt/1/clock$SERIALNUMBER.db
IMPORT_DB=/mnt/1/clock.db
CURRENT_DB=/var/local/data/capeclock.db
CURRENT_JOURNAL=/var/local/data/capeclock.db-journal
BACKUP_DB=/mnt/1/capeclock$SERIALNUMBER.db.before.restore
BACKUP_JOURNAL=/mnt/1/capeclock$SERIALNUMBER.db-journal.before.restore
SQLITE_SHELL=/usr/local/bin/sqlite3shell
#ALTER_SQL=/var/local/data/alter.sql
ALTER_SQL=/usr/local/bin/alter.sql
LOG2=/var/local/data/capeclock$SERIALNUMBER.restore.log

#msg "Restoring from Serial Number: $SERIALNUMBER"
msg "Restoring from: $IMPORT_DB"
/usr/local/bin/mount_usb
#largeflash=`mount | grep /mnt/3 | grep sda`
#if [ -n "$largeflash" ];
#then
#  mount -t vfat -o umask=0000 /dev/sdb1 /mnt/1 > /dev/null 2>&1
#else
#  mount -t vfat -o umask=0000 /dev/sda1 /mnt/1 > /dev/null 2>&1 
#fi
result=`mount | grep /mnt/1`
if [ -n "$result" ];
then
  msg "USB drive mounted"
	/usr/local/bin/sendchild "USB Restore" "USB Drive Found" "" ""
else
	/usr/local/bin/sendchild "USB Restore" "USB Drive NOT Found" "" ""
	msg_error "USB Thumb drive not found"
	exit_fail 5
fi
echo "--DATE------------------------------------------------" >> $LOG
date >> $LOG
echo "--DISK SPACE------------------------------------------" >> $LOG
df >> $LOG
echo "--DATA FOLDER-----------------------------------------" >> $LOG
ls -l /var/local/data >> $LOG
echo "--IMPORT----------------------------------------------" >> $LOG
if [ ! -s $IMPORT_DB ] ; then
	msg_error "Database for restoring is missing from: $IMPORT_DB"
	exit_fail 3
fi

if [ ! -s $CURRENT_DB ] ; then
	msg_error "Current Database is missing. $CURRENT_DB"
	# exit_fail 3
fi

CURRENT_VERSION=`echo "select dbversion from _info;" | $SQLITE_SHELL $CURRENT_DB`
IMPORT_VERSION=`echo "select dbversion from _info;" | $SQLITE_SHELL $IMPORT_DB`

msg "Current Version = $CURRENT_VERSION"
msg "Import  Version = $IMPORT_VERSION"


if [ $IMPORT_VERSION -gt $CURRENT_VERSION ]; then
	msg_error "Trying to import a database that is newer than the system. You need to update this clock first!"
	exit_fail 4
fi

msg "Shutting down web server"
if [ -e '/etc/php.ini' ]; then
	#LX100
	/etc/init.d/httpd stop
else
	#G20
	/etc/init.d/lighttpd stop
fi	
killall php-cgi

msg "Shutting down clock applications"
#/etc/init.d/clock stop
/usr/local/bin/stopclock
killall sqlite3shell

/usr/local/bin/sendchild "USB Restore" "Clock Paused" "" ""

#msg "Backing up current database to: $CURRENT_DB.bak"
#cp -f $CURRENT_DB $CURRENT_DB.bak
msg "Backing up current database to: $BACKUP_DB"
/usr/local/bin/sendchild "USB Restore" "Backup" "Started" ""
/usr/local/bin/autobackup.sh --nostart
cp -f $CURRENT_DB $BACKUP_DB >> $LOG
cp -f $CURRENT_DB.bak $BACKUP_DB.oldbak >> $LOG
cp -f $CURRENT_JOURNAL $BACKUP_JOURNAL >> $LOG
/usr/local/bin/sendchild "USB Restore" "Backup" "Complete" ""

rm $CURRENT_JOURNAL >> $LOG
rm $CURRENT_DB >> $LOG
rm $CURRENT_DB.bak >> $LOG

msg "Importing new database"
/usr/local/bin/sendchild "USB Restore" "Database" "Importing" ""
echo cp -f $IMPORT_DB $CURRENT_DB >> $LOG
cp -f $IMPORT_DB $CURRENT_DB >> $LOG

msg "Configuring database file permissions"
chmod 0777 $CURRENT_DB >> $LOG

echo "--ALTER-----------------------------------------------" >> $LOG
msg "Applying alter.sql (You can ignore duplicate column and primary key errors...)"
/usr/local/bin/sendchild "USB Restore" "Database" "Updating" ""
$SQLITE_SHELL $CURRENT_DB < $ALTER_SQL

msg "Configuring new timezone"
/usr/local/bin/sendchild "USB Restore" "Database" "Updating" "Time Zone"
echo "update thisdev set tz_new = tz_current;" | $SQLITE_SHELL $CURRENT_DB
NEW_TZ=`echo "select tz_new from thisdev;" | $SQLITE_SHELL $CURRENT_DB`
msg "New TimeZone will be: $NEW_TZ"

/usr/local/bin/sendchild "USB Restore" "Will Reboot shortly" "" ""

NEW_VERSION=`echo "select dbversion from _info;" | $SQLITE_SHELL $CURRENT_DB`
msg "Imported Version is now = $NEW_VERSION"

NEW_VERSION=`echo "update thisdev set refreshdb=8;" | $SQLITE_SHELL $CURRENT_DB`
msg "Refresh DB is set to 8 = $NEW_VERSION"


msg "Starting clock applications"
# the clockos program will initiate a reboot because tz_new is set.
#/etc/init.d/clock start
/usr/local/bin/startclock

msg "Starting web server"
if [ -e '/etc/php.ini' ]; then
	#LX100
	/etc/init.d/httpd start
else
	#G20
	/etc/init.d/lighttpd start
fi	



msg "End of USB Restore"

cp $LOG $LOG2

exit_okay


# -----------------------------------------------------

