#!/bin/sh
# event number is passed as parameter 1
# suggested event numbers;
# 20	Backup
# 30	BundyScript (ie keypad or scheduled)
# 40 	Firmware Update
# 60	Manual (not used on the clock)
# 100	Rebooting
# 120	Shutting Down
# 150   Started
#
# API_SITE=http://api.cstimeclocks.com/ping
API_SITE=http://api.cstimeclocks.com/ping
CLOCK_BUILD_NUMBER=2042
CLOCK_VERSION=2.04b
HOSTNAME=$(hostname)
SERIAL=$(cat /var/local/data/SerialNumber.txt)
UPDATETYPE=$(cat /var/local/data/update_type)
DATE=$(date)
BACKUP_FILE="/var/local/data/Backup.txt"
BACKUP_SITE=$(cat $BACKUP_FILE)
DMESG=/var/tmp/dmsg.txt
MOUNT=/var/tmp/mount.txt
NETSTAT=/var/tmp/netstat.txt
PS=/var/tmp/ps.txt
LS=/var/tmp/ls.txt
DF=/var/tmp/df.txt
TOP=/var/tmp/top.txt
IFCONFIG=/var/tmp/ifconfig.txt
FDISK=/var/tmp/fdisk.txt
SSID=/var/tmp/wpa_supplicant.txt

# gather various current states
dmesg | tail -n 200 > $DMESG
mount > $MOUNT
ps aux > $PS
ls -l /var/local/data > $LS
df > $DF
top -n 1 -b > $TOP
ifconfig -a > $IFCONFIG
fdisk -l > $FDISK
netstat > $NETSTAT
cat /etc/wpa_supplicant.conf > $SSID
gzip -f $DMESG
gzip -f $MOUNT
gzip -f $PS
gzip -f $LS
gzip -f $DF
gzip -f $TOP
gzip -f $IFCONFIG
gzip -f $FDISK
gzip -f $NETSTAT
gzip -f $SSID
# send to monitoring server
curl -F serial=$SERIAL -F eventid=$1 -F desc=$2 -F hostname=$HOSTNAME -F updatetype=$UPDATETYPE -F version=$CLOCK_VERSION -F date="$DATE" -F backupsite=$BACKUP_SITE -F dmesg=@$DMESG.gz -F mount=@$MOUNT.gz -F ls=@$LS.gz -F ps=@$PS.gz -F df=@$DF.gz -F top=@$TOP.gz -F fdisk=@$FDISK.gz -F ifconfig=@$IFCONFIG.gz -F netstat=@$NETSTAT.gz -F wpasupplicant=@$SSID.gz $API_SITE
