#! /bin/sh

usage() {
	echo Usage: "$0" \<serial number\> \<startup speed\>
	echo "Startup speed can be 'fast' or 'slow'."
	echo "fast - The clock will not check for a modem."
	echo "slow - The clock will check whether a modem is attached on startup."
	exit 1
}

if [ $# != 2 ]
then
	usage
fi

if [[ $1 =~ ^[0-9]* ]] && [[ $1 -gt 0 ]];
then
	echo "Serial number is an integer"
else
	usage
fi

if [[ "$2" == "fast" || "$2" == "slow" ]]
then
	echo "Modem value is valid"
else
	usage
fi

echo " ----- Setting up Clock ----- "
echo " Formatting USB drive"
/usr/local/bin/formatusb.sh -detect

echo "Setting permissions"
chmod 0777 /var/log
chmod 0777 /var/log/lighttpd
chmod 0777 /var/log/lighttpd/*

echo Setting serial to "$1"
/usr/local/bin/setserial.sh "$1"

echo Detect big flash init
/usr/local/bin/dbf.sh usb

# Set up fast or slow start up
if [[ $2 == "fast" ]]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set modem = 2 where id  = 1;"
fi

if [[ $2 == "slow" ]]
then
	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set modem = 0 where id  = 1;"
fi

echo " ----- Done ----- "

exit 0
