#!/bin/sh

# -----------------------------------------------------
# this script populates the database with the current ip settings
# -----------------------------------------------------

DATABASE=/var/local/data/capeclock.db
SQLITE3SHELL=/usr/local/bin/sqlite3shell

DHCP=`sed '/^BOOTPROTO="/!d s/^BOOTPROTO="//;q' /etc/conf.d/net.eth0 | sed '/"$/!d s/"$//;q`
IP=`sed '/^IP="/!d s/^IP="//;q' /etc/conf.d/net.eth0 | sed '/"$/!d s/"$//;q`
NM=`sed '/^NETMASK="/!d s/^NETMASK="//;q' /etc/conf.d/net.eth0 | sed '/"$/!d s/"$//;q`
BC=`sed '/^BROADCAST="/!d s/^BROADCAST="//;q' /etc/conf.d/net.eth0 | sed '/"$/!d s/"$//;q`
GW=`sed '/^GATEWAY="/!d s/^GATEWAY="//;q' /etc/conf.d/net.eth0 | sed '/"$/!d s/"$//;q`

DNS1=`sed -n '1 p' /etc/resolv.conf | sed ' s/nameserver //;q`
DNS2=`sed -n '2 p' /etc/resolv.conf | sed ' s/nameserver //;q`
DNS3=`sed -n '3 p' /etc/resolv.conf | sed ' s/nameserver //;q`
DNS4=`sed -n '4 p' /etc/resolv.conf | sed ' s/nameserver //;q`

if [ $DHCP = 'dhcp' ] ; then
	DHCP=1
else
	DHCP=0
fi

echo "DHCP = $DHCP"
echo "IP = $IP"
echo "NM = $NM"
echo "BC = $BC"
echo "GW = $GW"
echo "DNS1 = $DNS1"
echo "DNS2 = $DNS2"
echo "DNS3 = $DNS3"
echo "DNS4 = $DNS4"

SQLCOMMAND="update thisdev set dhcp='$DHCP', ip='$IP', netmask='$NM', broadcast='$BC', gateway='$GW', nameserver1='$DNS1', nameserver2='$DNS2', nameserver3='$DNS3', nameserver4='$DNS4';"

echo "$SQLCOMMAND" | $SQLITE3SHELL $DATABASE 

#echo -e ".mode line\nselect * from thisdev;" | $SQLITE3SHELL $DATABASE 

# -----------------------------------------------------

